;========================================================================================
; Description:      Space War
; Author(s):        mrbond007 (Baki G)
;					Northwind (Frank Abbing)
;					JPAM (JPAM van der Ouderaa)
;
;					Remember if you like AutoIt Donate to the AutoIt Project:
;					http://www.autoitscript.com/donate.php
;========================================================================================
If _Singleton("Space War") = 0 Then Exit

#include "Plugins\ProSpeed.au3"
#include "Plugins\BassMod.au3"
#include "Plugins\Misc.au3"
#include "Plugins\Array.au3"
Opt("GUIOnEventMode", 1)
HotKeySet("{Esc}", "Close")

Global $MainGui, $GTitle = "Space War"
Global $ResourcePath = @ScriptDir & "\Space War\"
Global $MPath = $ResourcePath & "Music\"
Global $PPath = $ResourcePath & "Pictures\"
Global $Keys[2] = ["{LEFT}","{RIGHT}"], $PosX = 220, $Result, $KS = 1
Global $LevelsCount = 0, $Count = 0, $Split, $XX = 90, $YY = 10, $Bullet
Global $Load_Spr[27], $RockPos = 100, $Bullet2[1], $RandomBulletArray, $EnemieSpr[18]
Global $SpeedXY, $BulletSpeed = 2, $EnemieSs = 9, $Load_SP[2], $Level[2], $number = 0, $Dies = 0
Global $Enemies[50], $SprX, $SprY, $Fire, $Rock[4], $Star[15], $LoadedSprite, $Rrr, $GameRunning = 1
Global $XYParam[10] = ["15,26","19,22","19,23","19,25","23,23", _
					   "23,26","25,23","25,24","26,18","26,29"]
Global $Sprite1 = $PPath & "hero.png", _
		$Sprite2 = $PPath & "bullet1.png", _
		$Sprite3 = $PPath & "Explode.png", _
		$Sprite4 = $PPath & "Rock1.png", _
		$Sprite5 = $PPath & "Rock2.png", _
		$Sprite6 = $PPath & "Rock3.png", _
		$Sprite7 = $PPath & "bullet2.png", _
		$Sprite8 = $PPath & "Star.png", _
		$Sprite9 = $PPath & "Star2.png", _
		$Sprite10 = $PPath & "Star3.png", _
		$Shoot1 = $MPath & "001-System01.wav", _
		$Shoot2 = $MPath & "001-System02.wav", _
		$Shoot3 = $MPath & "001-System03.wav", _
		$Shoot4 = $MPath & "001-System04.wav", _
		$Sp1 = $PPath & "level.png", _
		$Sp2 = $PPath & "numbers.png"

For $i = 0 To UBound($EnemieSpr)-1
	$EnemieSpr[$i] = $PPath & "Enemie" & $i+1 & ".png"
Next

$MainGui = GUICreate($GTitle, 490, 400)
GUISetOnEvent(-3, "Close")
GUISetState()

DSoundInit()
$HeroShoot = DSoundLoad($Shoot1)
$EnemieShoot = DSoundLoad($Shoot2)
$Explotion = DSoundLoad($Shoot3)
$HExplotion = DSoundLoad($Shoot4)
$Background = Background($PPath & "fake.png", 0, 0, 490, 400)
For $i = 0 To 9
	$Load_Spr[$i] = LoadSprite(Eval("Sprite" & $i+1))
Next
For $i = 10 To 26
	$Load_Spr[$i] = LoadSprite($EnemieSpr[$i-10])
Next
For $i = 0 To UBound($Load_SP)-1
	$Load_SP[$i] = LoadSprite(Eval("Sp" & $i+1))
Next

$Hero = Sprite($Load_Spr[0], 0, 0, 39, 37, 1, 1, 0, 220, 360)
$Bullet = sprite($Load_Spr[1], 0, 0, 9, 13, 1, 1, 0, GetSpriteX($Hero)+15, -100)
SetSpriteSpeed($Hero, 4, 4)

For $i = 0 To UBound($Rock)-1
	$Rrr = _RandomMeteorSprite()
	$Rock[$i] = sprite($LoadedSprite, 0, 0, $Rrr, $Rrr, 8, 1, 0, (Random(-100, 100, 1))*($i+1), -200)
	SetSpriteSpeed($Rock[$i], 1, 1)
Next

For $i = 0 To UBound($Star)-1
	$Star[$i] = sprite($Load_Spr[Random(7, 9, 1)], 0, 0, 11, 11, 3, 1, 0, (Random(-100, 100, 1))*($i+1), -200)
	SetSpriteSpeed($Star[$i], 4, 4)
Next

_Create_Level()
_Keys(1)
_MoveAliens()
AdlibEnable("_MoveAliens", 250)
HotKeySet("z", "Pause")

$RandomTrack = Random(1, 2, 1)
If $RandomTrack = 1 Then
	_PrepareTrack($MPath & "Track1.xm")
	_BassVolume(100)
Else
	_PrepareTrack($MPath & "Track2.it")
	_BassVolume(50)
EndIf

While 1
	Sleep(100)
	_MeteorHit()
	_EnemiesDestroyed()
	_EnemiesBullets()
	Select
		Case $GameRunning = 0
			FreezeGame()
	EndSelect
WEnd

Func _Create_Level() ;create a new level
	Local $aDim = -1, $bDim, $RandomSpeed = Random(2, 4, 1)
	If $Count >= 10 Then Close()
	If Mod($Count, 3) = 0 Then ;enemie bullets speed increases each 3 levels
		$BulletSpeed += 1
		$SpeedXY = $BulletSpeed
	EndIf

	_ShowLevel_Info()
	$EnemieSs += 1
	$RandomBulletArray = Random(2, 5, 1) ;how many bullets the enemies will fire at you
	For $i = 0 To $RandomBulletArray
		$bDim += 1
		ReDim $Bullet2[$bDim]
		$Bullet2[$bDim-1] = Sprite($Load_Spr[6], 0, 0, 9, 13, 1, 1, 0, 0, -100)
		SetSpriteSpeed($Bullet2[$bDim-1], $SpeedXY, $SpeedXY)
	Next

	$YY = 10
	$Count += 1
	$Split = StringSplit($XYParam[$Count-1], ",") ;enemies sprites and X Y dimensions
	For $a = 0 To 4
		For $b = 0 To 9
			$aDim += 1
			$XX += 25
			$Enemies[$aDim] = Sprite($Load_Spr[$EnemieSs], 0, 0, $Split[1], $Split[2], 1, 1, 0, $XX, $YY)
			SetSpriteSpeed($Enemies[$aDim], $RandomSpeed, $RandomSpeed)
		Next
		$XX = 90
		$YY += 40
	Next
EndFunc

Func _ShowLevel_Info()
	HotKeySet("z")

	If $Dies = 0 Then $number += 1
	$Level[0] = sprite($Load_SP[0], 0, 0, 61, 21, 1, 1, 0, -100, 190) ;displays level number
	$Level[1] = sprite($Load_SP[1], 0, 0, 26, 21, 13, $number, 0, 500, 190)

	SetSpriteSpeed($Level[0], 5, 5)
	SetSpriteSpeed($Level[1], 4, 4)
	MoveSprite($Level[0], 175, 190)
	MoveSprite($Level[1], 270, 190)
	Sleep(3500)
	DeleteSprite($Level[0])
	DeleteSprite($Level[1])

	HotKeySet("z", "pause")
EndFunc

Func _MeteorHit() ;did the bullet hit the meteors or hero?
	For $i = 0 To UBound($Rock)-1
		If Collide($Bullet, $Rock[$i]) <> 0 Then
			_DrawBullet() ;reset the bullet if it hits the meteor
			ExitLoop
		ElseIf Collide($Hero, $Rock[$i]) <> 0 Then
			_Hero_Dies() ;kills the hero if meteor hits the hero
			ExitLoop
		EndIf
	Next
EndFunc

Func _DrawBullet() ;redraws the bullet on screen
	DeleteSprite($Bullet)
	$Bullet = sprite($Load_Spr[1], 0, 0, 9, 13, 1, 1, 0, GetSpriteX($Hero)+15, GetSpriteY($Hero)+40)
	SetSpriteSpeed($Bullet, 4, 4)
EndFunc

Func _Hero_Dies() ;when your ship is destroyed, resets everything (except for the enemies)
	_Keys(0)
	HotKeySet("z")
	AdlibDisable()
	For $i = 0 To UBound($Enemies)-1
		MoveSprite($Enemies[$i], GetSpriteX($Enemies[$i]), GetSpriteY($Enemies[$i]))
	Next
	For $i = 0 To UBound($Bullet2)-1
		MoveSprite($Bullet2[$i], GetSpriteX($Bullet2[$i]), GetSpriteY($Bullet2[$i]))
		DeleteSprite($Bullet2[$i])
	Next

	$PusX = GetSpriteX($Hero)
	$PusY = GetSpriteY($Hero)
	DeleteSprite($Hero)
	DSoundPlay($HExplotion, 0, 0)
	_DrawBullet()
	$Fire = sprite($Load_Spr[2], -5, 0, 25, 25, 8, 1, 0, $PusX, $PusY+10)
	SetSpriteAnim($Fire, -5, 0, 25, 25, 8, 1, 1)
	Sleep(600)
	DeleteSprite($Fire)
	_Create_Meteor()

	$Hero = Sprite($Load_Spr[0], 0, 0, 39, 37, 1, 1, 0, 220, 360)
	SetSpriteSpeed($Hero, 4, 4)
	$PosX = 220
	$Dies = 1
	_ShowLevel_Info()
	$Dies = 0

	_Keys(1)
	HotKeySet("z", "pause")
	_MoveAliens()
	AdlibEnable("_MoveAliens", 250)
	_RandomBullet()
EndFunc

Func _EnemiesDestroyed() ;checks to see if the enemies are hit
	If UBound($Enemies) = 0 Then Level_Finished() ;all enemies are destroyed ?

	For $i = 0 To UBound($Enemies)-1
		If Collide($Bullet, $Enemies[$i]) <> 0 Then ;when the bullet touches the enemie
			$SprX = GetSpriteX($Enemies[$i])
			$SprY = GetSpriteY($Enemies[$i])
			DeleteSprite($Enemies[$i]) ;kill the enemie
			DeleteSprite($Bullet)
			DSoundPlay($Explotion, 0, 0)
			$Fire = sprite($Load_Spr[2], -5, 0, 25, 25, 8, 1, 0, GetSpriteX($Enemies[$i]), GetSpriteY($Enemies[$i])) ;sets fire animation when the enemie is destroyed
			SetSpriteAnim($Fire, -5, 0, 25, 25, 8, 1, 1)
			Sleep(100)
			DeleteSprite($Fire)
			$Bullet = sprite($Load_Spr[1], 0, 0, 9, 13, 1, 1, 0, GetSpriteX($Hero)+15, GetSpriteY($Hero)+40)
			SetSpriteSpeed($Bullet, 4, 4)
			_ArrayDelete($Enemies, $i)
			ExitLoop
		EndIf
	Next
EndFunc

Func Level_Finished()
	_Keys(0)
	AdlibDisable()
	For $i = 0 To UBound($Bullet2)-1
		DeleteSprite($Bullet2[$i])
	Next
	For $i = 0 To UBound($Bullet2)-1
		_ArrayDelete($Bullet2, $i)
	Next

	Dim $Bullet2[1]
	Dim $Enemies[50]
	$PosX = 220
	MoveSprite($Hero, 220, 360)
	For $i = 0 To UBound($Rock)-1
		DeleteSprite($Rock[$i])
		$Rrr = _RandomMeteorSprite()
		$Rock[$i] = sprite($LoadedSprite, 0, 0, $Rrr, $Rrr, 8, 1, 0, (Random(-100, 100, 1))*($i+1), -200)
		SetSpriteAnim($Rock[$i], 0, 0, $Rrr, $Rrr, 8, 1, 10)
		SetSpriteSpeed($Rock[$i], 1, 1)
		MoveSprite($Rock[$i], 0, -200)
	Next
	Do
		Sleep(50)
	Until HasSpriteArrived($Hero) <> 0
	_Create_Level()

	_Keys(1)
	_MoveAliens()
	AdlibEnable("_MoveAliens", 250)
EndFunc

Func _EnemiesBullets() ;checks to see if the bullets fired by enemies has hit the hero
	For $i = 0 To UBound($Bullet2)-1
		If Collide($Hero, $Bullet2[$i]) <> 0 Then
			_Hero_Dies()
			ExitLoop
		EndIf
	Next
EndFunc

Func _MoveAliens() ;moves the enemies
	Local $szMove, $szCopy, $szAdd, $szTotal

	_RandomStar() ;moves the stars around
	_RandomMeteor() ;moves the meteors around
	_RandomBullet() ;enemies shoots a bullet at you
	$szMove = _RandomMovements() ;moves the enemies left & right
	$szCopy = $szMove
	$szTotal = UBound($Enemies)
	For $o = 0 To UBound($Enemies)-1 ;when all enemies has reached the position (left or right)
		If HasSpriteArrived($Enemies[$o]) <> 0 Then $szAdd += 1 ;count the enemies
	Next

	If $szAdd = $szTotal Then ;if the counted enemies equals the total amount of enemies
		For $i = 0 To UBound($Enemies)-1
			If Mod($i, 10) = 0 Then $szMove = $szCopy ;used to see if the enemies reached 10 space to left or right
			$szMove += 25
			MoveSprite($Enemies[$i], $szMove-15, GetSpriteY($Enemies[$i])) ;moves the enemies around
		Next
	EndIf
EndFunc

Func _RandomStar() ;creates and moves random stars
	For $i = 0 To UBound($Star)-1
		If HasSpriteArrived($Star[$i]) <> 0 Then
			DeleteSprite($Star[$i])
			$Star[$i] = sprite($Load_Spr[Random(7, 9, 1)], 0, 0, 11, 11, 3, 1, 0, (Random(-100, 100, 1))*($i+1), -200)
			SetSpriteAnim($Star[$i], 0, 0, 11, 11, 3, 1, 10)
			SetSpriteSpeed($Star[$i], 4, 4)
			MoveSprite($Star[$i], Random(0, 450, 1), 400)
			ExitLoop
		EndIf
	Next
EndFunc

Func _RandomMeteor() ;create and moves new meteors
	Local $szRandom = Random(1, 25, 1)

	If $szRandom = 1 Or $szRandom = 10 Or $szRandom = 20 Or $szRandom = 25 Then
		For $i = 0 To UBound($Rock)-1
			If HasSpriteArrived($Rock[$i]) <> 0 Then
				DeleteSprite($Rock[$i])
				$Rrr = _RandomMeteorSprite()
				$Rock[$i] = sprite($LoadedSprite, 0, 0, $Rrr, $Rrr, 8, 1, 0, (Random(-100, 100, 1))*($i+1), -200)
				SetSpriteAnim($Rock[$i], 0, 0, $Rrr, $Rrr, 8, 1, 10)
				SetSpriteSpeed($Rock[$i], 1, 1)
				MoveSprite($Rock[$i], Random(0, 450, 1), 400)
				ExitLoop
			EndIf
		Next
	EndIf
EndFunc

Func _RandomMeteorSprite() ;randomly chooses sprites for the meteors
	Local $MeteorSz = Random(1, 3, 1)
	Select
		Case $MeteorSz = 1
			$LoadedSprite = $Load_Spr[3]
			Return 30
		Case $MeteorSz = 2
			$LoadedSprite = $Load_Spr[4]
			Return 20
		Case $MeteorSz = 3
			$LoadedSprite = $Load_Spr[5]
			Return 29
	EndSelect
EndFunc

Func _RandomBullet() ;choose a random enemie to fire a bullet
	Local $RandomEnemie

	If UBound($Enemies) > 0 Then
		For $i = 0 To UBound($Bullet2)-1
			If HasSpriteArrived($Bullet2[$i]) <> 0 Then
				DeleteSprite($Bullet2[$i])
				$RandomEnemie = Random(0, UBound($Enemies)-1, 1)
				$Bullet2[$i] = Sprite($Load_Spr[6], 0, 0, 9, 13, 1, 1, 0, GetSpriteX($Enemies[$RandomEnemie]), GetSpriteY($Enemies[$RandomEnemie]))
				SetSpriteSpeed($Bullet2[$i], 2, $BulletSpeed)
				MoveSprite($Bullet2[$i], GetSpriteX($Enemies[$RandomEnemie]), 600)
				DSoundPlay($EnemieShoot, 0, 0)
				ExitLoop
			EndIf
		Next
	EndIf
EndFunc

Func _RandomMovements() ;how the enemies will move, left or right?
	Local $CurVal = Random(1, 10, 1)

	If $CurVal = 1 Or $CurVal = 3 Or $CurVal = 5 Or $CurVal = 7 Or $CurVal = 9 Then
		$CurVal = 0
	Else
		$CurVal = 230
	EndIf

	Return $CurVal
EndFunc

Func _Create_Meteor() ;creates and moves the new meteors
	For $i = 0 To UBound($Rock)-1
		DeleteSprite($Rock[$i])
	Next

	For $i = 0 To UBound($Rock)-1
		$Rrr = _RandomMeteorSprite()
		$Rock[$i] = sprite($LoadedSprite, 0, 0, $Rrr, $Rrr, 8, 1, 0, (Random(-100, 100, 1))*($i+1), -200)
		SetSpriteSpeed($Rock[$i], 1, 1)
	Next
EndFunc

Func _Keys($szParam) ;enables/disables hotkeys
	If $szParam = 1 Then
		For $i = 0 To UBound($Keys)-1
			HotKeySet($Keys[$i], "_KeyPressed")
		Next
		HotKeySet("{Space}", "_Fire")
	Else
		For $i = 0 To UBound($Keys)-1
			HotKeySet($Keys[$i])
		Next
		HotKeySet("{Space}")
	EndIf
EndFunc

Func _KeyPressed() ;which key has been pressed
	If HasSpriteArrived($Hero) <> 0 And WinActive($MainGui) Then ;when the hero has already reached the previous destination
		Select
			Case @HotKeyPressed = "{LEFT}" ;checks to see if you pressed the left key
				$PosX -= 20 ;calculates the next destination
				If $PosX <= 5 Then $PosX = 5 ;creates a cage so that the hero cannot move outside the gui
			Case @HotKeyPressed = "{RIGHT}"
				$PosX += 20
				If $PosX >= 450 Then $PosX = 450
		EndSelect
		MoveSprite($Hero, $PosX, 360) ;moves the hero
	EndIf
EndFunc

Func _Fire() ;hero fires a bullet
	If HasSpriteArrived($Bullet) <> 0 Then ;when the bullet reaches the previous destination
		DeleteSprite($Bullet) ;the bullet gets deleted
		$Bullet = sprite($Load_Spr[1], 0, 0, 9, 13, 1, 1, 0, GetSpriteX($Hero)+15, GetSpriteY($Hero)-10) ;and recreated
		SetSpriteSpeed($Bullet, 4, 4)
		MoveSprite($Bullet, GetSpriteX($Hero)+15, -20)
		DSoundPlay($HeroShoot, 0, 0)
	EndIf
EndFunc

Func Pause() ;prepares the game to be paused
	If $Ks = 1 Then
		$Ks = 0
		$GameRunning = 0 ;declared in the main loop (used to stop the game)
		_PauseMusic()
		_Keys(0)
		$Result = _FreezeAll()
		AdlibDisable()
		WinSetTitle($MainGui, "", "Paused")
	Else
		$Ks += 1
		$GameRunning = 1
		_PlayMusic()
		_Keys(1)
		_UNFreezeAll()
		_MoveAliens()
		AdlibEnable("_MoveAliens", 250)
		WinSetTitle($MainGui, "", $GTitle)
	EndIf
EndFunc

Func FreezeGame()
	Do
		Sleep(50)
	Until $GameRunning = 1
EndFunc

Func _FreezeAll() ;freezes all sprites on screen
	Local $BPosX, $BPosY
	For $i = 0 To UBound($Bullet2)-1
		$BPosX = GetSpriteX($Bullet2[$i])
		$BPosY = GetSpriteY($Bullet2[$i])
		MoveSprite($Bullet2[$i], $BPosX, $BPosY)
	Next
	For $i = 0 To UBound($Enemies)-1
		$BPosX = GetSpriteX($Enemies[$i])
		$BPosY = GetSpriteY($Enemies[$i])
		MoveSprite($Enemies[$i], $BPosX, $BPosY)
	Next
	For $i = 0 To UBound($Rock)-1
		$BPosX = GetSpriteX($Rock[$i])
		$BPosY = GetSpriteY($Rock[$i])
		MoveSprite($Rock[$i], $BPosX, $BPosY)
	Next

	$BPosX = GetSpriteX($Bullet)
	$BPosY = GetSpriteY($Bullet)
	MoveSprite($Bullet, $BPosX, $BPosY)
	Return $BPosY
EndFunc

Func _UNFreezeAll() ;unfreezes the sprites
	Local $BPosX
	For $i = 0 To UBound($Bullet2)-1
		$BPosX = GetSpriteX($Bullet2[$i])
		MoveSprite($Bullet2[$i], $BPosX, 600)
	Next
	For $i = 0 To UBound($Rock)-1
		$BPosX = GetSpriteX($Rock[$i])
		MoveSprite($Rock[$i], Random(0, 450, 1), 400)
	Next

	$BPosX = GetSpriteX($Bullet)
	If $Result < GetSpriteY($Hero) Then
		MoveSprite($Bullet, $BPosX, -100)
	Else
		MoveSprite($Bullet, $BPosX, $Result)
	EndIf
EndFunc

Func Close() ;close the gui and frees the allocated resources
	HotKeySet("{ESC}")
	HotKeySet("z")
	_Keys(0)
	AdlibDisable()
	FreeExtBmp($Background)
	DeleteAllSprites()
	_StopMusic()
	_FreeBass()
	GUIDelete($MainGui)
	SplashImageOn("", $PPath & "GOTFP.jpg", 272, 75, -1, -1, 1)
	Sleep(3500)
	SplashOff()
	Exit
EndFunc